<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Resources\Json\JsonResource;

class TherapistCommunitysResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $therapist_community_settings = $this->relationLoaded('therapist_community_settings') ? $this->whenLoaded('therapist_community_settings'):null;
        $therapist_community_categories = $this->relationLoaded('therapist_community_categories') ? $this->whenLoaded('therapist_community_categories'):null;
        $therapist_community_therapists = $this->relationLoaded('therapist_community_therapists') ? $this->whenLoaded('therapist_community_therapists') : null;
        $therapist_community_reviews = $this->relationLoaded('therapist_community_reviews') ? $this->whenLoaded('therapist_community_reviews'):null;
        $pricing_plan = $this->relationLoaded('pricing_plan') ? $this->whenLoaded('pricing_plan'):null;
        $appointments = $this->relationLoaded('appointments') ? $this->whenLoaded('appointments'):null;

        if($therapist_community_reviews){
            $rating = $therapist_community_reviews->avg('rating');
            if(!$rating){
                $rating = 0;
            }else{
                $rating = round($rating,2);
            }
        }else{
            $rating = 0;
        }
        return [
            "id" => $this->id,
            "user_id" => $this->user_id,
            "country_id" => $this->country_id,
            "state_id" => $this->state_id,
            "city_id" => $this->city_id,
            "name" => $this->name,
            "first_name" => $this->first_name,
            "last_name" => $this->last_name,
            "therapist_community_name" => $this->therapist_community_name,
            "therapist_community_website" => $this->therapist_community_website,
            "description" => $this->description,
            "description_translations" =>  $this->getTranslations('description'),
            "address_line_1" => $this->address_line_1,
            "address_line_2" => $this->address_line_2,
            "user_name" => $this->user_name,
            "zip_code" => $this->zip_code,
            "is_approved" => $this->is_approved,
            "approved_at" => $this->approved_at,
            "is_active" => $this->is_active,
            "is_featured" => $this->is_featured,
            "icon" => $this->icon,
            "image" => $this->image,
            "cover_image" => $this->cover_image,
            "rating" => $rating,
            'pricing_plan' => $pricing_plan,

            "booked_appointments" => isset($appointments) && count($appointments) ? count($appointments) : 0,
            "therapist_community_modules" => $pricing_plan ? $pricing_plan->therapist_community_modules()->pluck('pricing_plan_modules.module_code')->toArray():[],
            "therapist_community_settings" => isset($therapist_community_settings) && count($therapist_community_settings) > 0 ? TherapistCommunitySettingsResource::collection($this->whenLoaded('therapist_community_settings',function(){
                    return $this->therapist_community_settings;
            }))->pluck('value','name')->toArray(): null,
            "therapist_community_category_ids" => isset($therapist_community_categories) && count($therapist_community_categories) > 0 ? TherapistCommunityCategoriesResource::collection($this->whenLoaded('therapist_community_categories',function(){
                return $this->therapist_community_categories;
            }))->pluck('id')->toArray():null,
            "therapist_community_therapists" => $therapist_community_therapists ? TherapistsResource::collection($therapist_community_therapists) : [],
            "therapist_community_categories" => $therapist_community_categories ? TherapistCommunityCategoriesResource::collection($therapist_community_categories):[],
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
        ];
    }
}
